
function [sys,x0 ]=IndutionMotorWithCapacitor(t,x,u,flag)

rs=0.60; %0.60;       %0.668;  %/1.08;
rr=0.48;  % 0.48;       %0.58;
lls=2.5e-3; %2.5e-3;    %2.9e-3;
llr=2.5e-3; %2.5e-3; %2.9e-3;
llr1=2.5e-3; %2.5e-3;%2.9e-3;

lm1=151e-3; %151e-3;   %104e-3; %fundamental
rc1=422;   %422;  %311
lm3=14e-3; %14e-3;      %10.4e-3;%thirdharmonic
rc3=21;  %21;    %28;
%---------------------------
kc1=rc1/lm1;%fundamental
kc2=1/lls;
kc3=-1/llr;
kc4=-lm1/llr;

kc5=rc3/lm3;%thirdharmonic
kc6=1/lls;
kc7=-1/llr;
kc8=-lm3/llr;
%----------------------------
a=2*pi/5;
sina=sin(a);      sin2a=sin(2*a);
sin3a=sin(3*a);   sin4a=sin(4*a);
cosa=cos(a);      cos2a=cos(2*a);
cos3a=cos(3*a);   cos4a=cos(4*a);



R=1;
L=0.0200;
Vdc=300;
C=0.001;

if(flag==0)
%initial values for the phase currents and capacitor voltage
x0=[0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0.50*Vdc ];
sys=[18;0;21;7;0;1 ];
%switching functions formulation:
%sx2=1 means the phase x is connected to the +ve dc rail (vx0=Vdc )
%sx1=1 means the phase x is connected to the neutral point (vx0=Vdc/2 )
%sx1=0 and sx2=0 means the phase x is connected to the Cve dc rail (vx0=0 )
%where x=a,b and c .
elseif(flag==1)
if(u(1)==2)
sa2=1;sa1=0;
elseif(u(1)==1);
sa2=0;sa1=1;
else
sa2=0;sa1=0;
end

if(u(2)==2) 
sb2=1;sb1=0;
elseif(u(2)==1);
sb2=0;sb1=1;
else
sb2=0;sb1=0;
end

if(u(3)==2)
sc2=1;sc1=0;
elseif(u(3)==1);
sc2=0;sc1=1;
else
sc2=0;sc1=0;
end

if(u(3)==2)
sc2=1;sc1=0;
elseif(u(3)==1);
sc2=0;sc1=1;
else
sc2=0;sc1=0;
end

if(u(4)==2)
sd2=1;sd1=0;
elseif(u(4)==1);
sd2=0;sd1=1;
else
sd2=0;sd1=0;
end

if(u(5)==2)
se2=1;se1=0;
elseif(u(5)==1);
se2=0;se1=1;
else
se2=0;se1=0;
end

wr=u(7);
vc1=x(18);vc2=Vdc-x(18);
%calculation of output voltage with respect to Cve dc rail and then phase voltage
va=(sa1+sa2)*x(18)+sa2*vc2;
vb=(sb1+sb2)*x(18)+sb2*vc2;
vc=(sc1+sc2)*x(18)+sc2*vc2;
vd=(sd1+sd2)*x(18)+sd2*vc2;
ve=(se1+se2)*x(18)+se2*vc2;

vn=(va+vb+vc+vd+ve)/5;
van=va-vn;
vbn=vb-vn;
vcn=vc-vn;
vdn=vd-vn;
ven=ve-vn;

%  vn=(u(1)+u(2)+u(3)+u(4)+u(5))/5;
%  van=u(1)-vn;
%  vbn=u(2)-vn;
%  vcn=u(3)-vn;
%  vdn=u(4)-vn;
%  ven=u(5)-vn;

%calculation of neutral current
%in=sa1*x(13)+sb1*x(14)+sc1*x(15)+x(16)*sd1+x(17)*se1;
MidPointCurrent= sa1*((0.4)*(x(1)+x(7)))+sb1*((0.4)*(cosa*x(1)+sina*x(4)+cos3a*x(7)+sin3a*x(10)))+sc1*((0.4)*(cos2a*x(1)+sin2a*x(4)+cosa*x(7)+sina*x(10)))+sd1*((0.4)*(cos3a*x(1)+sin3a*x(4)+cos4a*x(7)+sin4a*x(10)))+se1*((0.4)*(cos4a*x(1)+sin4a*x(4)+cos2a*x(7)+sin2a*x(10)));
%differential equations describe the ac transient for static load and dc transient
dx13=(van -R*x(13))/L;
dx14=(vbn -R*x(14))/L;
dx15=(vcn -R*x(15))/L;
dx16=(vdn -R*x(16))/L;
dx17=(ven -R*x(17))/L;

dx18=-MidPointCurrent/(2*C);

    vd1ss=(0.4)*(van+cosa*vbn+cos2a*vcn+cos3a*vdn+cos4a*ven);
    vq1ss=(0.4)*(    sina*vbn+sin2a*vcn+sin3a*vdn+sin4a*ven);
    vd3ss=(0.4)*(van+cos3a*vbn+cosa*vcn+cos4a*vdn+cos2a*ven);
    vq3ss=(0.4)*(    sin3a*vbn+sina*vcn+sin4a*vdn+sin2a*ven);

    id1ms_n=(x(1)+x(3)-x(2))*kc1;
    iq1ms_n=(x(4)+x(6)-x(5))*kc1;
    id1ss_n=(vd1ss-x(1)*rs-id1ms_n*lm1)*kc2;
    iq1ss_n=(vq1ss-x(4)*rs-iq1ms_n*lm1)*kc2;
    id1rs_n=x(3)*rr*kc3+id1ms_n*kc4+(x(5)*kc4-x(6))*wr;
    iq1rs_n=x(6)*rr*kc3+iq1ms_n*kc4+(x(3)-x(2)*kc4)*wr;

    id3ms_n=(x(7)+x(9)-x(8))*kc5;
    iq3ms_n=(x(10)+x(12)-x(11))*kc5;
    id3ss_n=(vd3ss-x(7)*rs-id3ms_n*lm3)*kc6;
    iq3ss_n=(vq3ss-x(10)*rs-iq3ms_n*lm3)*kc6;
    id3rs_n=x(9)*rr*kc7+id3ms_n*kc8+3*(x(11)*kc8-x(12))*wr;
    iq3rs_n=x(12)*rr*kc7+iq3ms_n*kc8+3*(x(9)-x(8)*kc8)*wr;
    


sys=[id1ss_n;id1ms_n;id1rs_n;iq1ss_n;iq1ms_n;iq1rs_n;id3ss_n;id3ms_n;id3rs_n;iq3ss_n;iq3ms_n;iq3rs_n;dx13;dx14;dx15;dx16;dx17;dx18;];

elseif(flag==3)
if(u(1)==2)
sa2=1;sa1=0;
elseif(u(1)==1);
sa2=0;sa1=1;
else
sa2=0;sa1=0;
end
if(u(2)==2)
sb2=1;sb1=0;
elseif(u(2)==1);
sb2=0;sb1=1;
else
sb2=0;sb1=0;
end
if(u(3)==2)
sc2=1;sc1=0;
elseif(u(3)==1);
sc2=0;sc1=1;
else
sc2=0;sc1=0;
end

if(u(4)==2)
sd2=1;sd1=0;
elseif(u(4)==1);
sd2=0;sd1=1;
else
sd2=0;sd1=0;
end

if(u(5)==2)
se2=1;se1=0;
elseif(u(5)==1);
se2=0;se1=1;
else
se2=0;se1=0;
end


vc1=x(18);
vc2=Vdc-x(18);
va=(sa1+sa2)*x(18)+sa2*vc2;
vb=(sb1+sb2)*x(18)+sb2*vc2;
vc=(sc1+sc2)*x(18)+sc2*vc2;
vd=(sd1+sd2)*x(18)+sd2*vc2;
ve=(se1+se2)*x(18)+se2*vc2;
% va=u(1);
% vb=u(2);
% vc=u(3);
% vd=u(4);
% ve=u(5);

vn=(va+vb+vc+vd+ve)/5;
van=va-vn;
vbn=vb-vn;
vcn=vc-vn;
vdn=vd-vn;
ven=ve-vn;

%calculation of neutral current
in=(sa1*x(1)+sb1*x(2)+sc1*x(3)+x(4)*sd1+x(5)*se1);
ic1=in/2;
ic2=ic1;

ia=(x(1)+x(7));
ib=(cosa*x(1)+sina*x(4)+cos3a*x(7)+sin3a*x(10));
ic=(cos2a*x(1)+sin2a*x(4)+cosa*x(7)+sina*x(10));
id=(cos3a*x(1)+sin3a*x(4)+cos4a*x(7)+sin4a*x(10));
ie=(cos4a*x(1)+sin4a*x(4)+cos2a*x(7)+sin2a*x(10));
    
in= sa1*((0.4)*(x(1)+x(7)))+sb1*((0.4)*(cosa*x(1)+sina*x(4)+cos3a*x(7)+sin3a*x(10)))+sc1*((0.4)*(cos2a*x(1)+sin2a*x(4)+cosa*x(7)+sina*x(10)))+sd1*((0.4)*(cos3a*x(1)+sin3a*x(4)+cos4a*x(7)+sin4a*x(10)))+se1*((0.4)*(cos4a*x(1)+sin4a*x(4)+cos2a*x(7)+sin2a*x(10)));
%in=(sa1*x(1)+sb1*x(2)+sc1*x(3)+x(4)*sd1+x(5)*se1);
ic1=in/2;
ic2=ic1;

id1ss=x(1);id1rs=x(3);iq1ss=x(4);iq1rs=x(6);
lamda_d1rs=lm1*id1ss+(lm1+llr1)*id1rs;
lamda_q1rs=lm1*iq1ss+(lm1+llr1)*iq1rs;
    
lamda_d1ss=lm1*id1rs+(lm1+lls)*id1ss;
lamda_q1ss=lm1*iq1rs+(lm1+lls)*iq1ss;
    
   
te=2.5*(lm1*(x(5)*x(3)-x(2)*x(6))+3*lm3*(x(11)*x(9)-x(8)*x(12)));
    
sys=[ia;ib;ic;id;ie;va;vb;vc;vd;ve;vc1;vc2;in;va-vb;te;id1ss;iq1ss;lamda_d1rs;lamda_q1rs;lamda_d1ss;lamda_q1ss;];
else
sys=[];
end